varying vec2 texture_coordinate;
varying vec2 image_coordinate;
uniform sampler2D source;
uniform sampler2D image;

void main() {
	vec3 color = texture2D(source, texture_coordinate).rgb;
	vec3 overlay = texture2D(image, image_coordinate).rgb;
	vec3 center = vec3(0.5,0.5,0.5);
	
	float b = (color.b - 0.5) * (overlay.b * 2.0) + 0.5;
	color = vec3(0,0,b);
	gl_FragColor = vec4(clamp(color, 0.0, 1.0),1);
}
